<?php 
/*#################################################################*\
|# Licence Number 0CIM-0718-0K3L-0209
|# -------------------------------------------------------------   #|
|# Copyright (c)2009 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	
/**
# ################################################################################
# Project:   PHP Link Directory
#
# **********************************************************************
# Copyright (C) 2004-2009 NetCreated, Inc. (http://www.netcreated.com/)
#
# This software is for use only to those who have purchased a license.
# A license must be purchased for EACH installation of the software.
#
# By using the software you agree to the terms:
#
#    - You may not redistribute, sell or otherwise share this software
#      in whole or in part without the consent of the the ownership
#      of PHP Link Directory. Please contact david@david-duval.com
#      if you need more information.
#
#    - You agree to retain a link back to http://www.phplinkdirectory.com/
#      on all pages of your directory in you purchased the $25 version
#      of the software.
#
# License holders are entitled to upgrades to the 3.4 branch of the software
# as they are made available at http://www.phplinkdirectory.com/
#
# In some cases, license holders may be required to agree to changes
# in the software license before receiving updates to the software.
# **********************************************************************
#
# For questions, help, comments, discussion, etc., please join the
# PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
#
# @link           http://www.phplinkdirectory.com/
# @copyright      2004-2009 NetCreated, Inc. (http://www.netcreated.com/)
# @projectManager David DuVal <david@david-duval.com>
# @package        PHPLinkDirectory
# @version        4.0.0
# ################################################################################
*/
class MySpaceVideo extends Widget {
	var $name;
	var $type;
	var $tpl;
	
	function MySpaceVideo($name='', $type='', $tpl='') {
		$this->name = $name;
		$this->type = $type;
		$this->tpl = get_widget_tpl($name);
		$this->tpl->assign('date_format', '%D %H:%M:%S');
	}
	
	function getContent() {
		global $db;
		global $tables;
	    	    
		$set = $this->getFrontSettings();
		if ($set['DISPLAY_IN_BOX'] == "No") {
			$this->tpl->assign('show_title_vertical', 1);
		}
		
	$url = 'http://mediaservices.myspace.com/services/rss.ashx?fuseaction=vids.charts&RSSAction=VideoCharts';

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	$data = curl_exec($ch);
	curl_close($ch);
	
	$doc = new SimpleXmlElement($data, LIBXML_NOCDATA);
	
	if(isset($doc->channel->item))
		$items = $this->parseRSS($doc, $set);
		
	$this->tpl->assign("items", $items);
	$this->tpl->assign($set);

	return $this->tpl->fetch('content.tpl');

	}
	
	function parseRSS($xml, $set) {
		$items = '';
		$i = 0;
		foreach($xml->channel->item as $entry) {
			if ($i == $set["MV_ITEMS_NUM"])
				break;
				
			$namespaces = $entry->getNameSpaces(true);
			$media = $entry->children($namespaces['media']);
			$myspace = $entry->children($namespaces['myspace']);
			$description = (string)$entry->description;
			$title = (string)$entry->title;
			$media_title = (string)$media->title;
			
			if(strlen($description) > $set["MV_DESCR_LEN"])
				$description = substr($description, 0, $set["MV_DESCR_LEN"])."...";
			if(strlen($title) > $set["MV_TITLE_LEN"]) {
				$title = substr($title, 0, $set["MV_TITLE_LEN"])."...";
				$media_title = substr($media_title, 0, $set["MV_TITLE_LEN"])."...";
			}
			
			$items[$i]["thumbnail"] = (string)$media->thumbnail->attributes()->url;
			$items[$i]["plays"] = $myspace->statistics->attributes()->plays;
			$items[$i]["url"] = (string)$entry->guid;
			$items[$i]["title"] = $title;
			$items[$i]["media_title"] = $media_title;
			$items[$i]["description"] = $description;
		
			$i++;	
		}
		
		return $items;
	}
}

?>