<?php

require_once '../../include/config.php';
require_once 'include/tables.php';
require_once 'include/functions.php';
require_once 'libs/adodb/adodb.inc.php';
//Add custom database library extender
require_once 'include/adodb_extender.php';
require_once 'libs/intsmarty/intsmarty.class.php';

session_start();

$server_doc_root = substr(dirname (__file__), 0, strrpos(dirname(__file__), DIRECTORY_SEPARATOR));
$server_doc_root = substr($server_doc_root, 0,strrpos($server_doc_root, DIRECTORY_SEPARATOR) + 1);

$db = ADONewConnection(DB_DRIVER);
if ($db->Connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME))
{
   $db->SetFetchMode(ADODB_FETCH_ASSOC);
   //Load extenders to count executions
   $db->fnExecute = 'CountExecs';
   $db->fnCacheExecute = 'CountCachedExecs';
}



if (!empty($_REQUEST['submit'])) {
	$template_name = clean_string_paranoia($_REQUEST['USER_TEMPLATE']);
	if (file_exists($server_doc_root.'templates/'.$template_name)) {
		$_SESSION['USER_TEMPLATE'] = $template_name;	
		$tpl = new IntSmarty('en');

   	$tpl->template_dir = INSTALL_PATH.'templates/'.$template_name.'/';
   	$tpl->compile_dir  = INSTALL_PATH.'temp/templates';
   	$tpl->cache_dir    = INSTALL_PATH.'temp/cache';
		
		$tpl->cache_lifetime = 0;
      $tpl->clear_all_cache();
      $tpl->clear_compiled_tpl();
	}
	
}

$redirect_to = $_SERVER['HTTP_REFERER'] ? $_SERVER['HTTP_REFERER'] : 'index.php';

http_custom_redirect($redirect_to, null, null, "Template changed");


?>