<?php 
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2010 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2010 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.1.0
 # ################################################################################
 */
 class FacebookComments extends Widget {
    public $name;
    public $type;
    public $tpl;
    
    protected $_dateFormat = 'l jS \of F Y h:i:s';


    public function __construct($name='', $type='', $tpl=''){
        $this->name = $name;
        $this->type = $type;
        $this->tpl = get_widget_tpl($name);
        $this->tpl->assign('date_format', '%D %H:%M:%S');
    }
	
    public function getContent(){
        global $db;
        global $tables;

        //article permission related
        $permission_cats = "0 ";
        $permission_cats_parents = "0 ";
        $permission_links_arts = "0 ";

        //get all settings
        $set = $this->getFrontSettings();
        if($set['DISPLAY_IN_BOX'] == "No"){
            $this->tpl->assign('show_title', 0);
        }else{
            $this->tpl->assign('show_title', 0);
        }
        $this->tpl->assign("TITLE", $set['TITLE']);
        if($set['FB_COMMENT_DATE_FORMAT']){
            $this->_dateFormat = $set['FB_COMMENT_DATE_FORMAT'];
        }
        $this->tpl->assign("FB_COMMENT_DATE_FORMAT", $this->_dateFormat);
        
        //get article data
        if(ENABLE_REWRITE == 1){
            $ext = array('.htm', '.html', '.php', '/');
            $id = explode('-', $_REQUEST['id']);
            $el = count($id) - 1;
            $id = intval(str_replace($ext, '', $id[$el]));
        }else{
            $id = (!empty ($_REQUEST['id']) ? intval ($_REQUEST['id']) : 0);
        }

        /*---------------------------------------------------------------------*/
        if(empty($id) || !preg_match ('`^[\d]+$`', $id)){
            $this->tpl->assign('error', "Invalid ID");
        }else{
            if($set['CACHE_RESULTS'] == "Yes"){
                $rdata = $db->CacheGetRow(
                    "SELECT *, DATE_FORMAT(DATE_ADDED, '%M %d, %Y %r') AS `DAT` 
                        FROM `{$tables['article']['name']}` 
                        WHERE `STATUS` = '2' AND `ID` = ".$db->qstr($id));
            }else{
                $rdata = $db->GetRow(
                        "SELECT *, DATE_FORMAT(DATE_ADDED, '%M %d, %Y %r') AS `DAT` 
                        FROM `{$tables['article']['name']}` 
                        WHERE `STATUS` = '2' AND `ID` = ".$db->qstr($id));
            }

            $data = array ();
            if(!$rdata){
		$tpl->assign('error', "Invalid ID [{$id}] passed - not found in database");
            }else{
                $data['ID']             = $id;
                $data['TITLE']          = $rdata['TITLE'];
                $data['DESCRIPTION']    = $rdata['DESCRIPTION'];
                $data['URL']            = $rdata['URL'];
                //$data['ARTICLE']        = stripslashes ($rdata['ARTICLE']);
                $data['ARTICLE']        = parse_article_units($rdata['ARTICLE']);
                $data['CATEGORY_ID']    = $rdata['CATEGORY_ID'];
                $data['DATE_MODIFIED']  = $rdata['DATE_MODIFIED'];
                $data['DATE_ADDED']     = $rdata['DAT'];
                $data['IPADRESS']       = $rdata['IPADRESS'];
                $data['META_KEYWORDS'] = $rdata['META_KEYWORDS'];
                $data['META_DESCRIPTION'] = $rdata['META_DESCRIPTION'];
                $data['STATUS']        = $rdata['STATUS'];
                $cdata = $db->GetRow("SELECT `TITLE` AS `CATEGORY_TITLE`, `CACHE_TITLE`, `CACHE_URL` FROM `{$tables['category']['name']}` WHERE `ID` = ".$db->qstr($rdata['CATEGORY_ID'])." LIMIT 1");
                $data['CATEGORY_TITLE'] = $cdata['CATEGORY_TITLE'];
                $data['CACHE_TITLE'] = $cdata['CACHE_TITLE'];
                $site_url = (substr (SITE_URL, -1) != '/' ? SITE_URL.'/' : SITE_URL);
                $data['CATEGORY_URL'] = $site_url;
                $data['CATEGORY_URL'] .= (ENABLE_REWRITE == 1 ? trim ($cdata['CACHE_URL']) : 'index.php?c='.$data['CATEGORY_ID']);
                $data['AD_BORDER_COLOR']       = $rdata['OWNER_ID'];
                $data['AD_PUBLISHER_ID']       = $rdata['AD_PUBLISHER_ID'];
                $data['AD_TITLE_COLOR']       = $rdata['AD_TITLE_COLOR'];
                $data['AD_TYPE']       = $rdata['AD_TYPE'];
                $data['AD_BACKGROUND_COLOR']       = $rdata['AD_BACKGROUND_COLOR'];
                $data['AD_TEXT_COLOR']       = $rdata['AD_TEXT_COLOR'];
                $data['AD_URL_COLOR']       = $rdata['AD_URL_COLOR'];
                $data['AD_EMBED']       = $rdata['AD_EMBED'];
                $data['AD_DETAIL_ONLY']       = $rdata['AD_DETAIL_ONLY'];
                $data['OWNER_ID']       = $rdata['OWNER_ID'];    
            }
        }
        //END get article data
            
        if(!isset($data) || !$data){
            $this->tpl->assign('error', "Invalid ID");
        }else{
            //get current url
            $url = (substr (SITE_URL, -1) != '/' ? SITE_URL.'/' : SITE_URL);
            $url .= seo_url($data['ID'], $data['TITLE'], REWRITE_TYPE, REWRITE_EXT, 1);
            //var_dump($url); die;
            
            //list($comments,$profilesById,$repliesByTarget) = $this->_loadComments($url);
            $comments = $this->_loadComments($url);
            //var_dump($comments/*,$profilesById,$repliesByTarget*/); die;
        }

        $this->tpl->assign('comments', $comments);

        return $this->tpl->fetch('content.tpl');
    }
    
    private function _loadComments($url)
    {
	// fql multiquery to fetch all the data we need to display in one go
	$queries = array(
            'q1' => 'select post_fbid, fromid, object_id, text, time from comment where object_id in (select comments_fbid from link_stat where url ="'.$url.'") ORDER BY time ',
            'q2' => 'select post_fbid, fromid, object_id, text, time from comment where object_id in (select post_fbid from #q1) ORDER BY time',
            'q3' => 'select name, id, url, pic_square from profile where id in (select fromid from #q1) or id in (select fromid from #q2)',
	);

	// note format json-strings is necessary because 32-bit php is not good at decoding 64-bit ints :(
	$result = json_decode(
                    file_get_contents(
                        'http://api.facebook.com/restserver.php?format=json-strings&method=fql.multiquery&queries='.
                         urlencode(json_encode($queries))
                    )
        );
        

	$comments = $result[0]->fql_result_set;
	$replies = $result[1]->fql_result_set;
	$profiles = $result[2]->fql_result_set;
	$profilesById = array();
	foreach($profiles as $profile){
            $profilesById[$profile->id] = $profile;
	}
	$repliesByTarget = array();
	foreach($replies as $reply){
            $profile = $profilesById[$reply->fromid];
            $reply->profile = $profile;
            $reply->postedAt = date($this->_dateFormat, $reply->time);
            $repliesByTarget[$reply->object_id][] = $reply;
	}
        
        foreach($comments as &$comment){
            $profile = $profilesById[$comment->fromid];
            $comment->profile = $profile;
            $comment->postedAt = date($this->_dateFormat, $comment->time);
	
            // print each reply
            $commentReplies = array();
            if(!empty($repliesByTarget[$comment->post_fbid])){
		foreach($repliesByTarget[$comment->post_fbid] as $reply){
                    $commentReplies[] = $reply;
		}
            }
            if($commentReplies){
                //var_dump($commentReplies); die;
            }
            $comment->replies = $commentReplies;
	}
        return $comments;
        /*return array(
            $comments,
            $profilesById,
            $repliesByTarget,
        );*/
    }
}
?>