(function($){
	$.fn.phpldSlide = function(options) {  
		var opt = {
			'bullets': true, 
			'auto': true, 
			'autoSpeed': 4000,
			'fadeSpeed': 1000
		};
		this.each(function() {        
			if (options) { 
				$.extend(opt, options);
			}
			
			$(this).children().wrapAll('<div class="phpldSlide" />');
			var container = $(this).find('.phpldSlide');
			container.find('img').wrapAll('<div class="phpld-slide-wrp" />');
			var wrp = container.find('.phpld-slide-wrp');
			wrp.append('<a href="#" class="prev"> </a><a href="#" class="next"> </a>');
			container.append('<div class="phpld-slide-nav" />');
			var nav = container.find('.phpld-slide-nav');

			wrp.find('img').each(function(i){
				if (opt.bullets === true) { 
						nav.append('<a href="#">&nbsp;</a>'); 
				}

				var title = $(this).attr('alt');
				$(this).wrapAll('<div class="phpld-slide-image" />');
				if (title !== undefined && title != '') {
						$(this).attr('title', '');
						$(this).before('<p>'+ title +'</p>');
				}
			});			
			
			var Slider = function(){
				this.imgs = wrp.find('div.phpld-slide-image');
				this.imgCount = (this.imgs.length) - 1; 
				this.navPrev = wrp.find('a.prev');
				this.navNext = wrp.find('a.next');
				this.bullets = container.find('.phpld-slide-nav a');
				this.captions = this.imgs.find('p');
				this.getCurrentIndex = function(){ 
					return this.imgs.filter('.current').index();
				};

			this.go = function(index){ 
					this.imgs.removeClass('current').fadeOut(opt.fadeSpeed).eq(index).fadeIn(opt.fadeSpeed).addClass('current');
					this.bullets.removeClass('current').eq(index).addClass('current');
					
			};
	
			this.next = function(){
					var index = this.getCurrentIndex();
					if (index < this.imgCount) {
						this.go(index + 1); 
					} else {
						this.go(0); 
					}
			};
	
			this.prev = function(){
					var index = this.getCurrentIndex();
					if (index > 0) {
						this.go(index - 1); 
					} else {
						this.go(this.imgCount); 
					}
			};	
	
			this.init = function(){ 
				this.imgs.hide().first().addClass('current').show(); 
				this.bullets.first().addClass('current');
			};
			};
			
			var slider = new Slider();
			slider.init();
			
			wrp.find('img').click(function(e){
				var id = $(this).attr('id');
				if($('#'+id+'_link') == undefined)
					return false;
				var href = $('#'+id+'_link').attr('href');
				if(href == undefined ||  href == '')
					return false;
				window.open(href);
				
			});

			wrp.hover(function(){
				var id = $(this).find('.current').find('img').attr('id');
				wrp.css("cursor","pointer");
				slider.captions.stop(true, true).fadeToggle();
				slider.navNext.stop(true, true).fadeToggle();
				slider.navPrev.stop(true, true).fadeToggle();
			});
			slider.navNext.click(function(e){ 
				e.preventDefault();
				slider.next(); 
			});
			slider.navPrev.click(function(e){ 
				e.preventDefault();
				slider.prev();
			});
			slider.bullets.click(function(e){ 
				e.preventDefault(); slider.captions.hide();
				slider.go($(this).index());
			});
			
			if (opt.auto === true) {
				var timer = function(){
						slider.next();
						slider.captions.hide();
				};
				var interval = setInterval(timer, opt.autoSpeed);
				wrp.hover(function(){clearInterval(interval);}, function(){interval=setInterval(timer, opt.autoSpeed);});
				slider.bullets.click(function(){clearInterval(interval); interval=setInterval(timer, opt.autoSpeed);});
			}
		});
	};
})(jQuery);
