<?php
/**
# ################################################################################
# Project:   PHP Link Directory
#
# **********************************************************************
# Copyright (C) 2004-2009 NetCreated, Inc. (http://www.netcreated.com/)
#
# This software is for use only to those who have purchased a license.
# A license must be purchased for EACH installation of the software.
#
# By using the software you agree to the terms:
#
#    - You may not redistribute, sell or otherwise share this software
#      in whole or in part without the consent of the the ownership
#      of PHP Link Directory. Please contact david@david-duval.com
#      if you need more information.
#
#    - You agree to retain a link back to http://www.phplinkdirectory.com/
#      on all pages of your directory in you purchased the $25 version
#      of the software.
#
# License holders are entitled to upgrades to the 3.4 branch of the software
# as they are made available at http://www.phplinkdirectory.com/
#
# In some cases, license holders may be required to agree to changes
# in the software license before receiving updates to the software.
# **********************************************************************
#
# For questions, help, comments, discussion, etc., please join the
# PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
#
# @link           http://www.phplinkdirectory.com/
# @copyright      2004-2009 NetCreated, Inc. (http://www.netcreated.com/)
# @projectManager David DuVal <david@david-duval.com>
# @package        PHPLinkDirectory
# @version        4.0.0
# ################################################################################
*/
class TopCategories extends Widget {
	var $name;
	var $type;
	var $tpl;
	
	function TopCategories($name='', $type='', $tpl='') {
		$this->name = $name;
		$this->type = $type;
		$this->tpl = get_widget_tpl($name);
		$this->tpl->assign('date_format', '%D %H:%M:%S');
	}
	
	function getContent() {
		global $db;
		global $tables;

		//article permission related
		if (isset($_SESSION['phpld']['user']['id'])) {
	        if (get_user_level($_SESSION['phpld']['user']['id']) == 1 || get_user_level($_SESSION['phpld']['user']['id']) == 3 ) {
	              $permission_cats = "1 ";
	              $permission_links_arts = "1 ";
	        } else {
	           $permissions = get_user_permissions($_SESSION['phpld']['user']['id']);
	           $permission_cats = "`ID` IN (";
	           $permission_links_arts = "`CATEGORY_ID` IN (";
	           if (count($permissions) >0) {
	               for ($i=0; $i<count($permissions); $i++) {
	                   if ($i<count($permissions)-1) {
	                        $permission_cats .= "'".$permissions[$i]['CATEGORY_ID']."', ";
	                        $permission_links_arts .= "'".$permissions[$i]['CATEGORY_ID']."', ";
	                   } else {
	                        $permission_cats .= "'".$permissions[$i]['CATEGORY_ID']."') ";
	                        $permission_links_arts .= "'".$permissions[$i]['CATEGORY_ID']."') ";
	                   }
	               }
	           } else {
	               $permission_cats = "0 ";
	               $permission_cats_parents = "0 ";
	               $permission_links_arts = "0 ";
	           }
	       }
	    } else {
	        $permission_cats = "0 ";
	        $permission_cats_parents = "0 ";
	        $permission_links_arts = "0 ";
	    }
	
		//end of article permission realted
	    	    
		$set = $this->getFrontSettings();
		if ($set['DISPLAY_IN_BOX'] == "No") {
			$this->tpl->assign('show_title', 1);
		}
		$this->tpl->assign("TITLE", $set['TITLE']);
		
		if ($set['CACHE_RESULTS'] == "Yes") {
			$mainCategs = $db->CacheGetAll("SELECT * FROM `{$tables['category']['name']}` 
				WHERE (`STATUS` = '2' OR {$permission_cats}) 
				AND `PARENT_ID` = 0 ORDER BY `".CATEG_FIELD_SORT."` ".CATEG_FIELD_SORT_ORDER);
		} else {
			$mainCategs = $db->GetAll("SELECT * FROM `{$tables['category']['name']}` 
				WHERE (`STATUS` = '2' OR {$permission_cats}) 
				AND `PARENT_ID` = 0 ORDER BY `".CATEG_FIELD_SORT."` ".CATEG_FIELD_SORT_ORDER);
		}
		
		$this->tpl->assign('mainCategs', $mainCategs);
						
		return $this->tpl->fetch('content.tpl');
	}
}

?>