<?php 
/*#################################################################*\
|# Licence Number 0CIM-0718-0K3L-0209
|# -------------------------------------------------------------   #|
|# Copyright (c)2009 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	
/**
# ################################################################################
# Project:   PHP Link Directory
#
# **********************************************************************
# Copyright (C) 2004-2009 NetCreated, Inc. (http://www.netcreated.com/)
#
# This software is for use only to those who have purchased a license.
# A license must be purchased for EACH installation of the software.
#
# By using the software you agree to the terms:
#
#    - You may not redistribute, sell or otherwise share this software
#      in whole or in part without the consent of the the ownership
#      of PHP Link Directory. Please contact david@david-duval.com
#      if you need more information.
#
#    - You agree to retain a link back to http://www.phplinkdirectory.com/
#      on all pages of your directory in you purchased the $25 version
#      of the software.
#
# License holders are entitled to upgrades to the 3.4 branch of the software
# as they are made available at http://www.phplinkdirectory.com/
#
# In some cases, license holders may be required to agree to changes
# in the software license before receiving updates to the software.
# **********************************************************************
#
# For questions, help, comments, discussion, etc., please join the
# PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
#
# @link           http://www.phplinkdirectory.com/
# @copyright      2004-2009 NetCreated, Inc. (http://www.netcreated.com/)
# @projectManager David DuVal <david@david-duval.com>
# @package        PHPLinkDirectory
# @version        4.0.0
# ################################################################################
*/
class NYTimes extends Widget {
	var $name;
	var $type;
	var $tpl;
	
	function NYTimes($name='', $type='', $tpl='') {
		$this->name = $name;
		$this->type = $type;
		$this->tpl = get_widget_tpl($name);
		$this->tpl->assign('date_format', '%D %H:%M:%S');
	}
	
	function getContent() {
		global $db;
		global $tables;

		$set = $this->getFrontSettings();
		if ($set['DISPLAY_IN_BOX'] == "No") {
			$this->tpl->assign('show_title_vertical', 1);
		}
		
		switch ($set['NYTIMES_TYPE']) {
			case 'New York / Region':
				$set['NYTIMES_NAME'] = 'NYRegion';
				break;
			case 'Health - Money and Policy':
				$set['NYTIMES_NAME'] = 'HealthCarePolicy';
				break;
			case 'Business - Your Money':
				$set['NYTIMES_NAME'] = 'YourMoney';
				break;
			case 'Most E-mailed':
				$set['NYTIMES_NAME'] = 'pop_top';
				break;
			default:
				$set['NYTIMES_NAME'] = str_replace(' ', '', $set['NYTIMES_TYPE']);
				break;
		}
		
		$set['NYTIMES_THUMB'] = ($set['NYTIMES_THUMB'] == 'Yes') ? 'hs' : 'ho';
		
		$set['NYTIMES_SRC'] = '[{"name":"rss_tw","title":"'.$set['NYTIMES_TYPE'].'","source":"http://www.nytimes.com/services/xml/rss/nyt/'.$set['NYTIMES_NAME'].'.xml","maxItems":"'.$set['NYTIMES_NUMBER'].'","displayType":"'.$set['NYTIMES_THUMB'].'"}]';		

		$this->tpl->assign($set);

		return $this->tpl->fetch('content.tpl');
	}
}

?>